<?xml version="1.0" encoding="UTF-8"?>
<!-- 
    AD - Address
    Status: draft
-->
<rule abstract="true" id="AD" xmlns="http://purl.oclc.org/dsdl/schematron">
    <extends rule="ANY"/>
    
    <!-- Test mixed content and empty address parts -->
    <assert role="error"
        test="@nullFlavor or (count(*)&gt;0 and not(text()[string-length(normalize-space())&gt;0])) or (count(*)=0 and text()[string-length(normalize-space())&gt;0])"
        >dtr1-1-AD: address shall be null or text only or element only (no mixed content)</assert>
    <assert role="error" test="not(@nullFlavor) or (not(hl7:thumbnail) or hl7:useablePeriod/@nullFlavor)">dtr1-2-AD: no useablePeriod if null</assert>
    <assert role="error" test="count(*[self::hl7:useablePeriod][@updateMode])=0">dtr1-3-AD: updateMode shall not be used on address elements</assert>
    
    <assert role="error" test="not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or 
        string-length(hl7:useablePeriod/hl7:low/@value) = string-length(hl7:useablePeriod/hl7:high/@value)"
        >dtr1-5-AD: useablePeriod/low/@value must have the same precision as useablePeriod/high/@value</assert>

    <assert role="error" test="not(hl7:useablePeriod/hl7:low/@value and hl7:useablePeriod/hl7:high/@value) or
        number(substring(concat(hl7:useablePeriod/hl7:low/@value,'00000000000000'),1,14)) &lt; number(substring(concat(hl7:useablePeriod/hl7:high/@value,'00000000000000'),1,14))"
        >dtr1-6-AD: useablePeriod/low/@value must be before useablePeriod/high/@value</assert>

    <!-- for width only us (microseconds),	ms (milliseconds),	s (seconds), min (minute), h (hours), d (day), wk (week), mo (month) and a (year) are allowed. -->
    <let name="tum" value="'^(us|ms|s|min|h|d|wk|mo|a|)$'"/>
    <assert role="error" test="matches(hl7:useablePeriod/hl7:width/@unit, $tum)"
        >dtr1-7-AD: for useablePeriod/width only us (microseconds), ms (milliseconds), s (seconds), min (minute), h (hours), d (day), wk (week), mo (month) or a (year) are allowed</assert>
    
    <!-- Test formaat postcode -->
    <let name="postalCodeText" value="hl7:postalCode/text()"/>
    <let name="countryCode" value="hl7:country/@code"/>
    <let name="countryCodeSystem" value="hl7:country/@codeSystem"/>
    <let name="countryText" value="upper-case(normalize-space(hl7:country))"/>
    
    <assert role="error" test="if (@codeSystem='2.16.840.1.113883.2.4.4.15') then (
        matches(@code,'^[0-9]{4}[A-Z]{2}$')
        ) else ( 1=1 )"
        >Datatype AD: postcodes onder codeSystem '2.16.840.1.113883.2.4.4.15' moeten voldoen aan '9999AA'</assert>
    
    <assert role="error" test="hl7:additionalLocator/text()=('to','by') or not(matches(hl7:postalCode/text(),'^[0-9]{4} [A-Z]{2}$')) or not(hl7:additionalLocator)"
        >Datatype AD: In een Nederlands adres kan additionalLocator alleen de waarden 'to' of 'by' bevatten</assert>
    
    <assert role="error"
        test="if (hl7:postalCode/text() and (not(hl7:country) or 
        ($countryCode='NL' and ($countryCodeSystem='2.16.1' or $countryCodeSystem='1.3.6.1.4.1.1466.115.121.1.11' or $countryCodeSystem='1.0.3166.1.2.2')) or
        ($countryCode='NLD' and $countryCodeSystem='2.16.2') or
        ($countryCode='528' and $countryCodeSystem='2.16.3') or
        $countryText='NL' or
        $countryText='NLD' or
        $countryText='NEDERLAND'
        )) then ( matches($postalCodeText,'^[0-9]{4} [A-Z]{2}$')
        ) else ( 1=1 )"
        >Datatype AD: Nederlandse postcodes in de text-nodes moeten voldoen aan '9999 AA'</assert>
    
    <let name="illegalAddressPart"
        value="*[local-name(.)!='delimiter' and local-name(.)!='buildingNumberSuffix' and
        local-name(.)!='country' and local-name(.)!='county' and
        local-name(.)!='city' and local-name(.)!='postalCode' and
        local-name(.)!='houseNumber' and local-name(.)!='streetName' and
        local-name(.)!='additionalLocator'][1]/name()"/>
    <assert role="error" test="count(*)=0 or string-length($illegalAddressPart)=0">Datatype AD: binnen Nederland mogen alleen delimiter, country, county, 
        city, postalCode, houseNumber, buildingNumberSuffix, streetName en additionalLocator worden gebruikt. Gevonden '<value-of select="$illegalAddressPart"/>'.</assert>
    
    <assert role="error" test="count(*)=0 or count(*[not(self::hl7:postalCode) and not(self::hl7:country) and @code])=0">Datatype AD: alleen postalCode en country 
        kunnen gecodeerd worden. Gevonden '<value-of select="*[not(self::hl7:postalCode) and not(self::hl7:country) and @code][1]/name()"/>'</assert>
    
</rule>
